import UIKit

extension ViewController
{
    override func touchesEnded(_ touches: Set<UITouch>,
                               with event: UIEvent?)
    {
        if (aTileIsAnimating)
        {
            return
        }
        let myTouch = touches.first
        
        if let tappedTile = myTouch?.view as? MyTile
        {
            if (foundTilesArr.contains(tappedTile))
            {
                return
            }
            
            aTileIsAnimating = true
            if (compareNow)
            {
                if (tappedTile == firstTile)
                {
                    aTileIsAnimating = false
                    return
                }
                secondTile = tappedTile
                flip(inpTile: secondTile,
                     animOpt: UIView.AnimationOptions.transitionFlipFromLeft,
                     bgColor: UIColor.orange,
                     inpTxt: "\(tappedTile.internalNum!)",
                    inpImg: tappedTile.internalImage!,
                    compare: true)
            }
            else
            {
                firstTile = tappedTile
                flip(inpTile: firstTile,
                     animOpt: UIView.AnimationOptions.transitionFlipFromLeft,
                     bgColor: UIColor.orange,
                     inpTxt: "\(tappedTile.internalNum!)",
                    inpImg: tappedTile.internalImage!,
                    compare: false)
            }
            
            compareNow = !compareNow
            
        }
    }
}
